/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.core;

import dev.xkmc.l2artifacts.content.core.ArtifactCurioCap;
import dev.xkmc.l2artifacts.content.core.ArtifactSet;
import dev.xkmc.l2artifacts.content.core.ArtifactSlot;
import dev.xkmc.l2artifacts.content.core.ArtifactStats;
import dev.xkmc.l2artifacts.content.core.RankedItem;
import dev.xkmc.l2artifacts.content.core.StatEntry;
import dev.xkmc.l2artifacts.content.upgrades.ArtifactUpgradeManager;
import dev.xkmc.l2artifacts.content.upgrades.Upgrade;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;

public class BaseArtifact
extends RankedItem {
    public static final String KEY = "ArtifactData";
    public static final String UPGRADE = "Upgrade";
    public final Supplier<ArtifactSet> set;
    public final Supplier<ArtifactSlot> slot;

    public static void upgrade(ItemStack stack, int exp, RandomSource random) {
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack).getSubTag(KEY);
        if (tag.isPresent()) {
            ArtifactStats stats = (ArtifactStats)TagCodec.fromTag((CompoundTag)tag.getOrCreate(), ArtifactStats.class);
            assert (stats != null);
            stats.addExp(exp, random);
            CompoundTag newTag = TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)stats);
            assert (newTag != null);
            tag.setTag(newTag);
        }
    }

    public static Optional<ArtifactStats> getStats(ItemStack stack) {
        return CuriosApi.getCurio((ItemStack)stack).filter(e -> e instanceof ArtifactCurioCap).flatMap(e -> ((ArtifactCurioCap)e).getStats());
    }

    public static Optional<Upgrade> getUpgrade(ItemStack stack) {
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack).getSubTag(UPGRADE);
        if (tag.isPresent()) {
            return Optional.ofNullable((Upgrade)TagCodec.fromTag((CompoundTag)tag.getOrCreate(), Upgrade.class));
        }
        return Optional.empty();
    }

    public static ItemStack setUpgrade(ItemStack stack, Upgrade upgrade) {
        CompoundTag tag = TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)upgrade);
        if (tag != null) {
            ItemCompoundTag.of((ItemStack)stack).getSubTag(UPGRADE).setTag(tag);
        }
        return stack;
    }

    public BaseArtifact(Item.Properties properties, Supplier<ArtifactSet> set, Supplier<ArtifactSlot> slot, int rank) {
        super(properties.m_41487_(1), rank);
        this.set = set;
        this.slot = slot;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return this.resolve(stack, level.m_5776_(), player.m_217043_());
    }

    public InteractionResultHolder<ItemStack> resolve(ItemStack stack, boolean isClient, RandomSource random) {
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack).getSubTag(KEY);
        Upgrade upgrade = BaseArtifact.getUpgrade(stack).orElse(new Upgrade());
        if (!tag.isPresent()) {
            if (!isClient) {
                ArtifactStats stats = ArtifactStats.generate(this.slot.get(), this.rank, upgrade, random);
                CompoundTag newTag = TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)stats);
                assert (newTag != null);
                tag.setTag(newTag);
                BaseArtifact.setUpgrade(stack, upgrade);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        Optional<ArtifactStats> opt = BaseArtifact.getStats(stack);
        if (opt.isPresent()) {
            ArtifactStats stats = opt.get();
            if (stats.level > stats.old_level) {
                if (!isClient) {
                    for (int i = stats.old_level + 1; i <= stats.level; ++i) {
                        ArtifactUpgradeManager.onUpgrade(stats, i, upgrade, random);
                    }
                    stats.old_level = stats.level;
                    CompoundTag newTag = TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)stats);
                    assert (newTag != null);
                    tag.setTag(newTag);
                    BaseArtifact.setUpgrade(stack, upgrade);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        boolean shift = Screen.m_96638_();
        if (Proxy.getClientPlayer() != null) {
            ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack).getSubTag(KEY);
            if (!tag.isPresent()) {
                list.add((Component)LangData.RAW_ARTIFACT.get(new Object[0]));
            } else {
                BaseArtifact.getStats(stack).ifPresent(stats -> {
                    boolean max = stats.level == ArtifactUpgradeManager.getMaxLevel(stats.rank);
                    list.add((Component)LangData.ARTIFACT_LEVEL.get(stats.level).m_130940_(max ? ChatFormatting.GOLD : ChatFormatting.WHITE));
                    if (stats.level < ArtifactUpgradeManager.getMaxLevel(stats.rank) && shift) {
                        list.add((Component)LangData.ARTIFACT_EXP.get(stats.exp, ArtifactUpgradeManager.getExpForLevel(stats.rank, stats.level)));
                    }
                    if (stats.level > stats.old_level) {
                        list.add((Component)LangData.UPGRADE.get(new Object[0]));
                    } else if (!shift) {
                        list.add((Component)LangData.MAIN_STAT.get(new Object[0]));
                        list.add(stats.main_stat.getTooltip());
                        if (!stats.sub_stats.isEmpty()) {
                            list.add((Component)LangData.SUB_STAT.get(new Object[0]));
                            for (StatEntry ent : stats.sub_stats) {
                                list.add(ent.getTooltip());
                            }
                        }
                    }
                });
            }
            list.addAll(this.set.get().getAllDescs(stack, shift));
            if (!shift) {
                list.add((Component)LangData.EXP_CONVERSION.get(ArtifactUpgradeManager.getExpForConversion(this.rank, BaseArtifact.getStats(stack).orElse(null))));
            }
        }
        super.m_7373_(stack, level, list, flag);
        if (!shift) {
            list.add((Component)LangData.SHIFT_TEXT.get(new Object[0]));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> new ArtifactCurioCap(stack)));
            }
        };
    }
}

